<?php
/**
 * ============================================
 * 🚀 INSTALADOR - RifaManager Pro v3
 * ============================================
 * 
 * Acesse: seusite.com/instalar.php
 * Delete após instalação!
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

$step = $_GET['step'] ?? 1;
$msg = '';
$msgType = '';

// Processa formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    if (isset($_POST['test_db'])) {
        // Testa conexão
        try {
            $dsn = "mysql:host={$_POST['db_host']};dbname={$_POST['db_name']};charset=utf8mb4";
            $pdo = new PDO($dsn, $_POST['db_user'], $_POST['db_pass'], [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
            ]);
            $msg = '✅ Conexão com banco de dados OK!';
            $msgType = 'success';
        } catch (Exception $e) {
            $msg = '❌ Erro: ' . $e->getMessage();
            $msgType = 'error';
        }
    }
    
    if (isset($_POST['install'])) {
        // Instala
        try {
            // 1. Cria config.php
            $configContent = '<?php
// Configuração do Banco de Dados
define("DB_TYPE", "mysql");
define("DB_HOST", "' . $_POST['db_host'] . '");
define("DB_NAME", "' . $_POST['db_name'] . '");
define("DB_USER", "' . $_POST['db_user'] . '");
define("DB_PASS", "' . $_POST['db_pass'] . '");

// Admin
define("ADMIN_USER", "' . ($_POST['admin_user'] ?: 'admin') . '");
define("ADMIN_PASS", "' . ($_POST['admin_pass'] ?: 'rifa@2026') . '");

// Timezone
date_default_timezone_set("America/Sao_Paulo");
';
            file_put_contents(__DIR__ . '/config.php', $configContent);
            
            // 2. Conecta ao banco
            $dsn = "mysql:host={$_POST['db_host']};dbname={$_POST['db_name']};charset=utf8mb4";
            $pdo = new PDO($dsn, $_POST['db_user'], $_POST['db_pass'], [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
            ]);
            
            // 3. Cria tabelas
            $sql = "
            -- OFERTAS
            CREATE TABLE IF NOT EXISTS offers (
                id INT AUTO_INCREMENT PRIMARY KEY,
                slug VARCHAR(50) NOT NULL UNIQUE,
                name VARCHAR(255) NOT NULL,
                description TEXT,
                emoji VARCHAR(10) DEFAULT '🎁',
                status VARCHAR(20) DEFAULT 'active',
                real_page_url VARCHAR(500) NOT NULL,
                white_page_url VARCHAR(500) DEFAULT 'https://google.com/',
                price_per_number DECIMAL(10,2) DEFAULT 0.00,
                
                cloaker_enabled TINYINT(1) DEFAULT 1,
                traffic_token VARCHAR(100) DEFAULT 'cm2025pro',
                token_param VARCHAR(20) DEFAULT 'ck',
                require_token TINYINT(1) DEFAULT 1,
                min_time_on_page INT DEFAULT 1,
                
                block_vpn TINYINT(1) DEFAULT 1,
                block_datacenter TINYINT(1) DEFAULT 1,
                block_tor TINYINT(1) DEFAULT 1,
                use_fingerprint TINYINT(1) DEFAULT 1,
                use_honeypot TINYINT(1) DEFAULT 1,
                
                allowed_countries TEXT,
                allow_mobile TINYINT(1) DEFAULT 1,
                allow_desktop TINYINT(1) DEFAULT 1,
                allow_tablet TINYINT(1) DEFAULT 1,
                
                gateway_id INT,
                gateway_custom_key TEXT,
                gateway_custom_company TEXT,
                
                fb_pixel_id VARCHAR(50),
                fb_access_token TEXT,
                fb_test_event_code VARCHAR(50),
                fb_capi_enabled TINYINT(1) DEFAULT 0,
                
                utmify_enabled TINYINT(1) DEFAULT 0,
                utmify_token VARCHAR(255),
                utmify_project_id VARCHAR(100),
                
                gads_enabled TINYINT(1) DEFAULT 0,
                gads_conversion_id VARCHAR(100),
                gads_conversion_label VARCHAR(100),
                
                tiktok_pixel_id VARCHAR(100),
                tiktok_access_token TEXT,
                
                stats_total_access INT DEFAULT 0,
                stats_passed INT DEFAULT 0,
                stats_blocked INT DEFAULT 0,
                stats_conversions INT DEFAULT 0,
                stats_revenue INT DEFAULT 0,
                
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                files_generated_at DATETIME
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

            -- DOMÍNIOS
            CREATE TABLE IF NOT EXISTS domains (
                id INT AUTO_INCREMENT PRIMARY KEY,
                offer_id INT NOT NULL,
                domain VARCHAR(255) NOT NULL UNIQUE,
                is_primary TINYINT(1) DEFAULT 0,
                is_active TINYINT(1) DEFAULT 1,
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                FOREIGN KEY (offer_id) REFERENCES offers(id) ON DELETE CASCADE
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

            -- GATEWAYS
            CREATE TABLE IF NOT EXISTS gateways (
                id INT AUTO_INCREMENT PRIMARY KEY,
                slug VARCHAR(50) NOT NULL UNIQUE,
                name VARCHAR(100) NOT NULL,
                api_url VARCHAR(500) NOT NULL,
                api_key TEXT,
                company_id VARCHAR(255),
                auth_type VARCHAR(20) DEFAULT 'apikey',
                auth_header VARCHAR(100) DEFAULT 'x-api-key',
                auth_prefix VARCHAR(50) DEFAULT '',
                endpoint_create VARCHAR(255) DEFAULT '/api/transactions',
                endpoint_status VARCHAR(255) DEFAULT '/api/transactions',
                status_field VARCHAR(100) DEFAULT 'status',
                qrcode_field VARCHAR(100) DEFAULT 'pix.qrcode',
                copypaste_field VARCHAR(100) DEFAULT 'pix.copiaECola',
                txid_field VARCHAR(100) DEFAULT 'id',
                valor_em_reais TINYINT(1) DEFAULT 0,
                is_default TINYINT(1) DEFAULT 0,
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

            -- TRANSAÇÕES
            CREATE TABLE IF NOT EXISTS transactions (
                id INT AUTO_INCREMENT PRIMARY KEY,
                offer_id INT NOT NULL,
                domain VARCHAR(255),
                tx_ref VARCHAR(100) UNIQUE NOT NULL,
                gateway_tx_id VARCHAR(255),
                customer_name VARCHAR(255),
                customer_email VARCHAR(255),
                customer_phone VARCHAR(50),
                customer_cpf VARCHAR(20),
                amount_cents INT NOT NULL,
                quantity INT DEFAULT 1,
                status VARCHAR(20) DEFAULT 'pending',
                utm_source VARCHAR(100),
                utm_medium VARCHAR(100),
                utm_campaign VARCHAR(255),
                utm_content VARCHAR(255),
                utm_term VARCHAR(255),
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                paid_at DATETIME,
                FOREIGN KEY (offer_id) REFERENCES offers(id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

            -- LOGS
            CREATE TABLE IF NOT EXISTS access_logs (
                id INT AUTO_INCREMENT PRIMARY KEY,
                offer_id INT NOT NULL,
                domain VARCHAR(255),
                ip_address VARCHAR(45),
                user_agent TEXT,
                referer TEXT,
                country VARCHAR(10),
                device_type VARCHAR(20),
                passed TINYINT(1) DEFAULT 0,
                block_reason VARCHAR(255),
                score INT DEFAULT 0,
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                INDEX idx_offer (offer_id),
                INDEX idx_created (created_at)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

            -- WEBHOOK LOGS
            CREATE TABLE IF NOT EXISTS webhook_logs (
                id INT AUTO_INCREMENT PRIMARY KEY,
                offer_id INT,
                gateway VARCHAR(50),
                payload TEXT,
                processed TINYINT(1) DEFAULT 0,
                result TEXT,
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
            ";
            
            // Executa cada statement separadamente
            $statements = array_filter(array_map('trim', explode(';', $sql)));
            foreach ($statements as $stmt) {
                if (!empty($stmt)) {
                    $pdo->exec($stmt);
                }
            }
            
            $msg = '✅ Instalação concluída com sucesso!';
            $msgType = 'success';
            $step = 3;
            
        } catch (Exception $e) {
            $msg = '❌ Erro na instalação: ' . $e->getMessage();
            $msgType = 'error';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>🚀 Instalador - RifaManager Pro</title>
<style>
:root{--bg:#0a0a0f;--card:#12121a;--border:rgba(255,255,255,.1);--text:#f8fafc;--muted:#64748b;--accent:#6366f1;--green:#10b981;--red:#ef4444}
*{margin:0;padding:0;box-sizing:border-box}
body{font-family:'Segoe UI',sans-serif;background:var(--bg);color:var(--text);min-height:100vh;display:flex;align-items:center;justify-content:center;padding:20px}
.container{background:var(--card);border:1px solid var(--border);border-radius:20px;padding:40px;max-width:600px;width:100%}
h1{font-size:28px;margin-bottom:10px;display:flex;align-items:center;gap:12px}
.ver{background:var(--green);color:#000;padding:4px 12px;border-radius:6px;font-size:12px;font-weight:700}
.subtitle{color:var(--muted);margin-bottom:30px}
.steps{display:flex;gap:10px;margin-bottom:30px}
.step{flex:1;padding:12px;background:var(--bg);border-radius:10px;text-align:center;font-size:13px;color:var(--muted)}
.step.active{background:var(--accent);color:#fff}
.step.done{background:var(--green);color:#fff}
.form-group{margin-bottom:20px}
.form-group label{display:block;font-size:13px;color:var(--muted);margin-bottom:8px;font-weight:600}
.form-group input{width:100%;padding:14px 16px;background:var(--bg);border:1px solid var(--border);border-radius:10px;color:var(--text);font-size:14px}
.form-group input:focus{outline:none;border-color:var(--accent)}
.form-group small{display:block;margin-top:6px;color:var(--muted);font-size:11px}
.row{display:grid;grid-template-columns:1fr 1fr;gap:16px}
.btn{display:inline-flex;align-items:center;justify-content:center;gap:8px;padding:14px 24px;border-radius:10px;font-size:14px;font-weight:600;cursor:pointer;border:none;width:100%;margin-top:10px}
.btn-primary{background:linear-gradient(135deg,var(--accent),#a855f7);color:#fff}
.btn-secondary{background:var(--bg);color:var(--text);border:1px solid var(--border)}
.btn-success{background:var(--green);color:#fff}
.msg{padding:14px 18px;border-radius:10px;margin-bottom:20px;font-size:14px}
.msg.success{background:rgba(16,185,129,.15);color:var(--green);border:1px solid var(--green)}
.msg.error{background:rgba(239,68,68,.15);color:var(--red);border:1px solid var(--red)}
.check-list{background:var(--bg);border-radius:12px;padding:20px}
.check-item{display:flex;align-items:center;gap:10px;padding:10px 0;border-bottom:1px solid var(--border)}
.check-item:last-child{border:none}
.check-item.ok{color:var(--green)}
.check-item.err{color:var(--red)}
.success-box{text-align:center;padding:30px}
.success-box .icon{font-size:64px;margin-bottom:20px}
.success-box h2{margin-bottom:10px}
.success-box p{color:var(--muted);margin-bottom:20px}
.success-box a{color:var(--accent);text-decoration:none;font-weight:600}
.warning{background:rgba(245,158,11,.15);color:#f59e0b;padding:14px;border-radius:10px;margin-top:20px;font-size:13px}
</style>
</head>
<body>
<div class="container">
    <h1>🎰 RifaManager <span class="ver">PRO v3</span></h1>
    <p class="subtitle">Instalador Automático</p>
    
    <div class="steps">
        <div class="step <?= $step >= 1 ? ($step > 1 ? 'done' : 'active') : '' ?>">1. Verificar</div>
        <div class="step <?= $step >= 2 ? ($step > 2 ? 'done' : 'active') : '' ?>">2. Banco de Dados</div>
        <div class="step <?= $step >= 3 ? 'active' : '' ?>">3. Concluído</div>
    </div>
    
    <?php if ($msg): ?>
    <div class="msg <?= $msgType ?>"><?= $msg ?></div>
    <?php endif; ?>
    
    <?php if ($step == 1): ?>
    <!-- STEP 1: VERIFICAÇÕES -->
    <div class="check-list">
        <?php
        $canProceed = true;
        
        // PHP
        $phpOk = version_compare(phpversion(), '7.4', '>=');
        echo '<div class="check-item ' . ($phpOk ? 'ok' : 'err') . '">' . ($phpOk ? '✅' : '❌') . ' PHP ' . phpversion() . ($phpOk ? '' : ' (mínimo 7.4)') . '</div>';
        if (!$phpOk) $canProceed = false;
        
        // PDO
        $pdoOk = extension_loaded('pdo');
        echo '<div class="check-item ' . ($pdoOk ? 'ok' : 'err') . '">' . ($pdoOk ? '✅' : '❌') . ' PDO</div>';
        if (!$pdoOk) $canProceed = false;
        
        // PDO MySQL
        $mysqlOk = extension_loaded('pdo_mysql');
        echo '<div class="check-item ' . ($mysqlOk ? 'ok' : 'err') . '">' . ($mysqlOk ? '✅' : '❌') . ' PDO MySQL</div>';
        if (!$mysqlOk) $canProceed = false;
        
        // cURL
        $curlOk = extension_loaded('curl');
        echo '<div class="check-item ' . ($curlOk ? 'ok' : 'err') . '">' . ($curlOk ? '✅' : '❌') . ' cURL</div>';
        if (!$curlOk) $canProceed = false;
        
        // JSON
        $jsonOk = extension_loaded('json');
        echo '<div class="check-item ' . ($jsonOk ? 'ok' : 'err') . '">' . ($jsonOk ? '✅' : '❌') . ' JSON</div>';
        if (!$jsonOk) $canProceed = false;
        
        // ZIP
        $zipOk = extension_loaded('zip');
        echo '<div class="check-item ' . ($zipOk ? 'ok' : 'err') . '">' . ($zipOk ? '✅' : '❌') . ' ZIP</div>';
        if (!$zipOk) $canProceed = false;
        ?>
    </div>
    
    <?php if ($canProceed): ?>
    <a href="?step=2"><button class="btn btn-primary">Próximo →</button></a>
    <?php else: ?>
    <div class="warning">⚠️ Corrija os erros acima antes de continuar. Entre em contato com sua hospedagem para ativar as extensões necessárias.</div>
    <?php endif; ?>
    
    <?php elseif ($step == 2): ?>
    <!-- STEP 2: BANCO DE DADOS -->
    <form method="POST">
        <div class="form-group">
            <label>Host do Banco</label>
            <input type="text" name="db_host" value="localhost" required>
            <small>Geralmente é "localhost"</small>
        </div>
        
        <div class="form-group">
            <label>Nome do Banco</label>
            <input type="text" name="db_name" value="monitor_rf-painel" required>
        </div>
        
        <div class="row">
            <div class="form-group">
                <label>Usuário</label>
                <input type="text" name="db_user" value="monitor_rf-painel" required>
            </div>
            <div class="form-group">
                <label>Senha</label>
                <input type="password" name="db_pass" value="b5E8=j#jm]z75]5Q" required>
            </div>
        </div>
        
        <hr style="border:0;border-top:1px solid var(--border);margin:25px 0">
        
        <h3 style="font-size:16px;margin-bottom:15px">👤 Credenciais do Admin</h3>
        
        <div class="row">
            <div class="form-group">
                <label>Usuário Admin</label>
                <input type="text" name="admin_user" value="admin">
            </div>
            <div class="form-group">
                <label>Senha Admin</label>
                <input type="text" name="admin_pass" value="rifa@2026">
            </div>
        </div>
        
        <button type="submit" name="test_db" class="btn btn-secondary">🔍 Testar Conexão</button>
        <button type="submit" name="install" class="btn btn-primary">🚀 Instalar</button>
    </form>
    
    <a href="?step=1" style="display:block;text-align:center;margin-top:15px;color:var(--muted);font-size:13px">← Voltar</a>
    
    <?php elseif ($step == 3): ?>
    <!-- STEP 3: CONCLUÍDO -->
    <div class="success-box">
        <div class="icon">🎉</div>
        <h2>Instalação Concluída!</h2>
        <p>O RifaManager Pro foi instalado com sucesso.</p>
        <a href="admin/" class="btn btn-success">🚀 Acessar Painel</a>
    </div>
    
    <div class="warning">
        ⚠️ <strong>IMPORTANTE:</strong> Delete este arquivo (instalar.php) por segurança!
    </div>
    
    <?php endif; ?>
</div>
</body>
</html>
