<?php
// Habilita erros para debug (remova em produção)
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

session_start();
header('Content-Type: application/json');

// Verifica se foi instalado
$configFile = __DIR__ . '/../config.php';
if (!file_exists($configFile)) {
    echo json_encode(['success' => false, 'error' => 'Sistema não instalado. Acesse /instalar.php']);
    exit;
}

// Tratamento de erros global
set_exception_handler(function($e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
    exit;
});

set_error_handler(function($errno, $errstr, $errfile, $errline) {
    throw new ErrorException($errstr, 0, $errno, $errfile, $errline);
});

require_once $configFile;
require_once __DIR__ . '/../includes/Database.php';
require_once __DIR__ . '/../includes/OfferGenerator.php';

try {
    $db = Database::getInstance();
    
    // Inicializa banco se necessário (SQLite only)
    if (!defined('DB_TYPE') || DB_TYPE !== 'mysql') {
        try { $db->fetchOne("SELECT 1 FROM offers LIMIT 1"); } 
        catch (Exception $e) { $db->init(); }
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => 'Erro no banco: ' . $e->getMessage()]);
    exit;
}

$action = $_POST['action'] ?? $_GET['action'] ?? '';
$loggedIn = isset($_SESSION['rifa_admin']) && $_SESSION['rifa_admin'] === true;

function needAuth() {
    global $loggedIn;
    if (!$loggedIn) { echo json_encode(['success' => false, 'error' => 'Não autorizado']); exit; }
}

function ok($data = []) { echo json_encode(['success' => true] + $data); exit; }
function err($msg) { echo json_encode(['success' => false, 'error' => $msg]); exit; }
function clean($v) { return htmlspecialchars(strip_tags(trim($v)), ENT_QUOTES, 'UTF-8'); }

switch ($action) {
    // ========== AUTH ==========
    case 'login':
        $user = defined('ADMIN_USER') ? ADMIN_USER : 'admin';
        $pass = defined('ADMIN_PASS') ? ADMIN_PASS : 'rifa@2026';
        
        if ($_POST['user'] === $user && $_POST['pass'] === $pass) {
            $_SESSION['rifa_admin'] = true;
            ok();
        }
        err('Credenciais inválidas');
        break;
        
    case 'logout':
        session_destroy();
        ok();
        break;
        
    case 'check':
        ok(['logged' => $loggedIn]);
        break;
    
    // ========== STATS ==========
    case 'stats':
        needAuth();
        $s = $db->fetchOne("SELECT COUNT(*) as offers, COALESCE(SUM(stats_total_access),0) as access, COALESCE(SUM(stats_passed),0) as passed, COALESCE(SUM(stats_blocked),0) as blocked, COALESCE(SUM(stats_revenue),0) as revenue FROM offers");
        ok(['data' => $s]);
        break;
    
    // ========== OFFERS ==========
    case 'offers':
        needAuth();
        $offers = $db->fetchAll("SELECT o.*, g.name as gateway_name, (SELECT COUNT(*) FROM domains WHERE offer_id = o.id) as domains_count FROM offers o LEFT JOIN gateways g ON o.gateway_id = g.id ORDER BY o.created_at DESC");
        foreach ($offers as &$o) {
            $o['domains'] = $db->fetchAll("SELECT * FROM domains WHERE offer_id = ?", [$o['id']]);
        }
        ok(['data' => $offers]);
        break;
        
    case 'offer':
        needAuth();
        $o = $db->fetchOne("SELECT * FROM offers WHERE id = ?", [(int)$_GET['id']]);
        if (!$o) err('Não encontrado');
        $o['domains'] = $db->fetchAll("SELECT * FROM domains WHERE offer_id = ?", [$o['id']]);
        ok(['data' => $o]);
        break;
        
    case 'offer_create':
        needAuth();
        $slug = preg_replace('/[^a-z0-9_-]/', '', strtolower($_POST['slug'] ?? ''));
        if (!$slug) err('Slug obrigatório');
        if ($db->exists('offers', 'slug = ?', [$slug])) err('Slug já existe');
        
        $id = $db->insert('offers', [
            'slug' => $slug,
            'name' => clean($_POST['name'] ?? ''),
            'real_page_url' => clean($_POST['real_url'] ?? ''),
            'white_page_url' => clean($_POST['white_url'] ?? '') ?: 'https://google.com/',
            'traffic_token' => clean($_POST['token'] ?? 'cm2025pro'),
            'price_per_number' => floatval($_POST['price'] ?? 0)
        ]);
        
        // Adiciona domínio principal se informado
        if (!empty($_POST['domain'])) {
            $domain = preg_replace('#^https?://#', '', clean($_POST['domain']));
            $domain = rtrim($domain, '/');
            if ($domain && !$db->exists('domains', 'domain = ?', [$domain])) {
                $db->insert('domains', ['offer_id' => $id, 'domain' => $domain, 'is_primary' => 1]);
            }
        }
        
        ok(['id' => $id]);
        break;
        
    case 'offer_update':
        needAuth();
        $id = (int)$_POST['id'];
        $db->update('offers', [
            'name' => clean($_POST['name'] ?? ''),
            'real_page_url' => clean($_POST['real_url'] ?? ''),
            'white_page_url' => clean($_POST['white_url'] ?? ''),
            'price_per_number' => floatval($_POST['price'] ?? 0),
            'status' => $_POST['status'] ?? 'active',
            'emoji' => $_POST['emoji'] ?? '🎁',
            'updated_at' => date('Y-m-d H:i:s')
        ], 'id = ?', [$id]);
        ok();
        break;
        
    case 'offer_cloaker':
        needAuth();
        $id = (int)$_POST['id'];
        $db->update('offers', [
            'cloaker_enabled' => !empty($_POST['enabled']) ? 1 : 0,
            'traffic_token' => clean($_POST['token'] ?? 'cm2025pro'),
            'token_param' => clean($_POST['param'] ?? 'ck'),
            'require_token' => !empty($_POST['require_token']) ? 1 : 0,
            'block_vpn' => !empty($_POST['block_vpn']) ? 1 : 0,
            'block_datacenter' => !empty($_POST['block_dc']) ? 1 : 0,
            'block_tor' => !empty($_POST['block_tor']) ? 1 : 0,
            'use_fingerprint' => !empty($_POST['fingerprint']) ? 1 : 0,
            'use_honeypot' => !empty($_POST['honeypot']) ? 1 : 0,
            'allowed_countries' => $_POST['countries'] ?? '["BR"]',
            'allow_mobile' => !empty($_POST['mobile']) ? 1 : 0,
            'allow_desktop' => !empty($_POST['desktop']) ? 1 : 0,
            'allow_tablet' => !empty($_POST['tablet']) ? 1 : 0,
            'updated_at' => date('Y-m-d H:i:s')
        ], 'id = ?', [$id]);
        ok();
        break;
        
    case 'offer_gateway':
        needAuth();
        $id = (int)$_POST['id'];
        $db->update('offers', [
            'gateway_id' => !empty($_POST['gateway_id']) ? (int)$_POST['gateway_id'] : null,
            'gateway_custom_key' => $_POST['custom_key'] ?? '',
            'gateway_custom_company' => $_POST['custom_company'] ?? '',
            'updated_at' => date('Y-m-d H:i:s')
        ], 'id = ?', [$id]);
        ok();
        break;
        
    case 'offer_pixel':
        needAuth();
        $id = (int)$_POST['id'];
        $db->update('offers', [
            'fb_pixel_id' => clean($_POST['pixel_id'] ?? ''),
            'fb_access_token' => $_POST['access_token'] ?? '',
            'fb_test_event_code' => clean($_POST['test_code'] ?? ''),
            'fb_capi_enabled' => !empty($_POST['capi']) ? 1 : 0,
            'updated_at' => date('Y-m-d H:i:s')
        ], 'id = ?', [$id]);
        ok();
        break;
        
    case 'offer_utmify':
        needAuth();
        $id = (int)$_POST['id'];
        $db->update('offers', [
            'utmify_enabled' => !empty($_POST['enabled']) ? 1 : 0,
            'utmify_token' => $_POST['token'] ?? '',
            'utmify_project_id' => clean($_POST['project'] ?? ''),
            'updated_at' => date('Y-m-d H:i:s')
        ], 'id = ?', [$id]);
        ok();
        break;
        
    case 'offer_gads':
        needAuth();
        $id = (int)$_POST['id'];
        $db->update('offers', [
            'gads_enabled' => !empty($_POST['enabled']) ? 1 : 0,
            'gads_conversion_id' => clean($_POST['conversion_id'] ?? ''),
            'gads_conversion_label' => clean($_POST['label'] ?? ''),
            'updated_at' => date('Y-m-d H:i:s')
        ], 'id = ?', [$id]);
        ok();
        break;
        
    case 'offer_tiktok':
        needAuth();
        $id = (int)$_POST['id'];
        $db->update('offers', [
            'tiktok_pixel_id' => clean($_POST['pixel_id'] ?? ''),
            'tiktok_access_token' => $_POST['access_token'] ?? '',
            'updated_at' => date('Y-m-d H:i:s')
        ], 'id = ?', [$id]);
        ok();
        break;
        
    case 'offer_toggle':
        needAuth();
        $db->update('offers', ['status' => $_POST['status'] ?? 'active'], 'id = ?', [(int)$_POST['id']]);
        ok();
        break;
        
    case 'offer_delete':
        needAuth();
        $db->delete('domains', 'offer_id = ?', [(int)$_POST['id']]);
        $db->delete('offers', 'id = ?', [(int)$_POST['id']]);
        ok();
        break;
        
    case 'offer_generate':
        needAuth();
        $gen = new OfferGenerator($db);
        $zipPath = $gen->generate((int)$_POST['id']);
        ok(['zip' => basename($zipPath)]);
        break;
    
    // ========== DOMAINS ==========
    case 'domain_add':
        needAuth();
        $offerId = (int)$_POST['offer_id'];
        $domain = preg_replace('#^https?://#', '', clean($_POST['domain'] ?? ''));
        $domain = rtrim($domain, '/');
        if (!$domain) err('Domínio obrigatório');
        if ($db->exists('domains', 'domain = ?', [$domain])) err('Domínio já existe');
        
        $id = $db->insert('domains', [
            'offer_id' => $offerId,
            'domain' => $domain,
            'is_primary' => !empty($_POST['primary']) ? 1 : 0
        ]);
        ok(['id' => $id]);
        break;
        
    case 'domain_delete':
        needAuth();
        $db->delete('domains', 'id = ?', [(int)$_POST['id']]);
        ok();
        break;
    
    // ========== GATEWAYS ==========
    case 'gateways':
        needAuth();
        $gw = $db->fetchAll("SELECT * FROM gateways ORDER BY is_default DESC, name");
        ok(['data' => $gw]);
        break;
        
    case 'gateway_create':
        needAuth();
        $slug = preg_replace('/[^a-z0-9_]/', '', strtolower($_POST['slug'] ?? ''));
        if (!$slug) err('Slug obrigatório');
        if ($db->exists('gateways', 'slug = ?', [$slug])) err('Slug já existe');
        
        $id = $db->insert('gateways', [
            'slug' => $slug,
            'name' => clean($_POST['name'] ?? ''),
            'api_url' => clean($_POST['api_url'] ?? ''),
            'api_key' => $_POST['api_key'] ?? '',
            'company_id' => $_POST['company_id'] ?? '',
            'auth_type' => $_POST['auth_type'] ?? 'apikey',
            'auth_header' => $_POST['auth_header'] ?? 'x-api-key',
            'auth_prefix' => $_POST['auth_prefix'] ?? '',
            'endpoint_create' => $_POST['endpoint_create'] ?? '/api/transactions',
            'status_field' => $_POST['status_field'] ?? 'status',
            'qrcode_field' => $_POST['qrcode_field'] ?? 'pix.qrcode',
            'copypaste_field' => $_POST['copypaste_field'] ?? 'pix.copiaECola',
            'txid_field' => $_POST['txid_field'] ?? 'id',
            'valor_em_reais' => !empty($_POST['valor_reais']) ? 1 : 0
        ]);
        ok(['id' => $id]);
        break;
        
    case 'gateway_default':
        needAuth();
        $db->query("UPDATE gateways SET is_default = 0");
        $db->update('gateways', ['is_default' => 1], 'id = ?', [(int)$_POST['id']]);
        ok();
        break;
        
    case 'gateway_delete':
        needAuth();
        $db->delete('gateways', 'id = ?', [(int)$_POST['id']]);
        ok();
        break;
    
    // ========== DOWNLOAD ==========
    case 'download':
        needAuth();
        $file = sys_get_temp_dir() . '/' . basename($_GET['file'] ?? '');
        if (!file_exists($file)) err('Arquivo não encontrado');
        
        header('Content-Type: application/zip');
        header('Content-Disposition: attachment; filename="' . basename($file) . '"');
        header('Content-Length: ' . filesize($file));
        readfile($file);
        exit;
        break;
    
    default:
        err('Ação inválida');
}
