<?php
session_start();
$loggedIn = isset($_SESSION['rifa_admin']) && $_SESSION['rifa_admin'] === true;
?><!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>🎰 RifaManager Pro v3</title>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
<style>
:root{--bg:#0a0a0f;--card:#12121a;--hover:#1a1a24;--border:rgba(255,255,255,.08);--text:#f8fafc;--muted:#64748b;--accent:#6366f1;--green:#10b981;--red:#ef4444;--yellow:#f59e0b;--purple:#a855f7;--cyan:#06b6d4}
*{margin:0;padding:0;box-sizing:border-box}body{font-family:Inter,sans-serif;background:var(--bg);color:var(--text);min-height:100vh}
.login{display:flex;align-items:center;justify-content:center;min-height:100vh}.login-box{background:var(--card);border-radius:20px;padding:48px;max-width:400px;width:100%;border:1px solid var(--border)}
.login-box h1{font-size:26px;margin-bottom:32px;display:flex;align-items:center;gap:12px}.ver{background:var(--green);color:#000;padding:4px 10px;border-radius:6px;font-size:11px;font-weight:700}
.fg{margin-bottom:20px}.fg label{display:block;font-size:13px;color:var(--muted);margin-bottom:8px;font-weight:600}
.fg input,.fg select,.fg textarea{width:100%;padding:12px 16px;background:#0f0f17;border:1px solid var(--border);border-radius:10px;color:var(--text);font-size:14px;font-family:inherit}
.fg input:focus,.fg select:focus{outline:none;border-color:var(--accent)}.fg small{display:block;margin-top:6px;color:var(--muted);font-size:11px}
.btn{display:inline-flex;align-items:center;justify-content:center;gap:8px;padding:12px 20px;border-radius:10px;font-size:14px;font-weight:600;cursor:pointer;border:none;transition:all .2s;font-family:inherit}
.btn-p{background:linear-gradient(135deg,var(--accent),var(--purple));color:#fff}.btn-s{background:var(--card);color:var(--text);border:1px solid var(--border)}
.btn-g{background:var(--green);color:#fff}.btn-d{background:var(--red);color:#fff}.btn-c{background:var(--cyan);color:#000}
.btn-sm{padding:8px 14px;font-size:12px}.btn-block{width:100%}
.app{display:flex;min-height:100vh}
.side{width:250px;background:var(--card);border-right:1px solid var(--border);padding:20px;display:flex;flex-direction:column;position:fixed;height:100vh}
.logo{display:flex;align-items:center;gap:10px;margin-bottom:28px}.logo-i{width:40px;height:40px;background:linear-gradient(135deg,var(--accent),var(--purple));border-radius:10px;display:flex;align-items:center;justify-content:center;font-size:20px}
.logo-t{font-weight:800;font-size:15px}.logo-t span{color:var(--accent)}.logo-t small{display:block;font-size:9px;color:var(--green)}
.nav-i{display:flex;align-items:center;gap:10px;padding:10px 12px;border-radius:8px;cursor:pointer;color:#94a3b8;font-size:13px;font-weight:500;margin-bottom:4px}
.nav-i:hover{background:var(--hover);color:var(--text)}.nav-i.active{background:rgba(99,102,241,.15);color:var(--accent)}
.nav-b{margin-left:auto;padding:2px 8px;border-radius:8px;font-size:10px;font-weight:700;background:var(--accent);color:#fff}
.side-f{margin-top:auto}.user{display:flex;align-items:center;gap:10px;padding:12px;background:var(--hover);border-radius:10px;cursor:pointer}
.user-a{width:32px;height:32px;border-radius:8px;background:var(--purple);display:flex;align-items:center;justify-content:center;font-weight:700;font-size:13px}
.main{margin-left:250px;flex:1;padding:24px}
.hdr{display:flex;justify-content:space-between;align-items:center;margin-bottom:24px}.hdr h1{font-size:24px;font-weight:800}.hdr p{color:var(--muted);font-size:12px;margin-top:4px}.hdr-a{display:flex;gap:8px}
.stats{display:grid;grid-template-columns:repeat(5,1fr);gap:14px;margin-bottom:24px}
.st{background:var(--card);border:1px solid var(--border);border-radius:12px;padding:18px;text-align:center}
.st-v{font-size:24px;font-weight:800;margin-bottom:2px}.st-l{font-size:10px;color:var(--muted);text-transform:uppercase}
.st:nth-child(1) .st-v{color:#3b82f6}.st:nth-child(2) .st-v{color:var(--green)}.st:nth-child(3) .st-v{color:var(--red)}.st:nth-child(4) .st-v{color:var(--purple)}.st:nth-child(5) .st-v{color:var(--cyan)}
.page{display:none}.page.active{display:block}
.cards{display:grid;grid-template-columns:repeat(auto-fill,minmax(400px,1fr));gap:16px}
.card{background:var(--card);border:1px solid var(--border);border-radius:14px;overflow:hidden}
.card-h{padding:16px;border-bottom:1px solid var(--border);display:flex;justify-content:space-between;align-items:flex-start}
.card-i{display:flex;gap:12px}.card-th{width:48px;height:48px;border-radius:10px;display:flex;align-items:center;justify-content:center;font-size:22px}
.card-n{font-size:15px;font-weight:700;margin-bottom:3px}.card-m{display:flex;gap:6px;flex-wrap:wrap}
.card-slug{font-size:10px;color:var(--muted);font-family:monospace;background:var(--hover);padding:2px 6px;border-radius:4px}
.card-st{padding:4px 10px;border-radius:12px;font-size:10px;font-weight:700}
.card-st.on{background:rgba(16,185,129,.15);color:var(--green)}.card-st.off{background:rgba(245,158,11,.15);color:var(--yellow)}
.card-stats{display:grid;grid-template-columns:repeat(4,1fr);padding:12px 16px;background:var(--hover)}
.card-stat{text-align:center}.card-stat-v{font-size:14px;font-weight:700}.card-stat-l{font-size:8px;color:var(--muted);text-transform:uppercase}
.card-cfg{padding:10px 16px;display:flex;flex-wrap:wrap;gap:5px}
.cfg{padding:3px 7px;background:var(--hover);border-radius:4px;font-size:9px;font-weight:600}.cfg.on{color:var(--green)}.cfg.off{color:var(--muted)}
.card-doms{padding:10px 16px;border-top:1px solid var(--border)}
.dom-tag{display:inline-flex;align-items:center;gap:4px;padding:4px 8px;background:rgba(6,182,212,.1);border-radius:6px;font-size:11px;color:var(--cyan);margin:2px}
.card-a{padding:12px 16px;border-top:1px solid var(--border);display:flex;gap:6px;flex-wrap:wrap}
.pnl{background:var(--card);border:1px solid var(--border);border-radius:14px;margin-bottom:16px;overflow:hidden}
.pnl-h{padding:14px 18px;border-bottom:1px solid var(--border);display:flex;justify-content:space-between;align-items:center}
.pnl-t{font-size:14px;font-weight:700}.pnl-b{padding:18px}
.grid{display:grid;gap:16px}.g2{grid-template-columns:repeat(2,1fr)}.g3{grid-template-columns:repeat(3,1fr)}
.gw{background:var(--hover);border:2px solid var(--border);border-radius:12px;padding:16px;margin-bottom:12px}
.gw.active{border-color:var(--green)}.gw-h{display:flex;justify-content:space-between;align-items:center;margin-bottom:12px}
.gw-n{font-size:15px;font-weight:700}.gw-bd{padding:3px 8px;border-radius:12px;font-size:10px;font-weight:700}
.gw-bd.on{background:var(--green);color:#fff}.gw-bd.off{background:var(--muted);color:#fff}
.gw-i{font-size:11px;color:var(--muted);margin-bottom:12px}.gw-i p{margin-bottom:4px}
.modal{position:fixed;top:0;left:0;right:0;bottom:0;background:rgba(0,0,0,.9);display:none;align-items:center;justify-content:center;z-index:1000;padding:20px}
.modal.active{display:flex}
.modal-c{background:var(--card);border:1px solid var(--border);border-radius:18px;width:100%;max-width:600px;max-height:90vh;overflow:hidden}
.modal-h{padding:18px 22px;border-bottom:1px solid var(--border);display:flex;justify-content:space-between;align-items:center}
.modal-t{font-size:17px;font-weight:800}
.modal-x{width:32px;height:32px;border-radius:8px;border:1px solid var(--border);background:transparent;color:var(--muted);cursor:pointer;font-size:18px}
.modal-b{padding:22px;max-height:calc(90vh - 140px);overflow-y:auto}.modal-f{padding:16px 22px;border-top:1px solid var(--border);display:flex;justify-content:flex-end;gap:8px}
.tabs{display:flex;gap:6px;margin-bottom:18px;flex-wrap:wrap}
.tab{padding:8px 14px;background:var(--hover);border:1px solid var(--border);border-radius:8px;font-size:11px;font-weight:600;cursor:pointer;color:var(--muted)}
.tab:hover{color:var(--text)}.tab.active{background:var(--accent);color:#fff;border-color:var(--accent)}
.tab-c{display:none}.tab-c.active{display:block}
.toggle{display:flex;align-items:center;gap:10px;padding:10px 0}
.toggle-sw{width:40px;height:22px;background:var(--border);border-radius:11px;position:relative;cursor:pointer;flex-shrink:0}
.toggle-sw.on{background:var(--green)}
.toggle-sw::after{content:'';position:absolute;width:16px;height:16px;background:#fff;border-radius:50%;top:3px;left:3px;transition:transform .2s}
.toggle-sw.on::after{transform:translateX(18px)}
.toggle-lbl{font-size:12px;font-weight:500}
.toast{position:fixed;bottom:20px;right:20px;background:var(--green);color:#fff;padding:12px 20px;border-radius:10px;font-weight:600;font-size:13px;z-index:9999}
.empty{text-align:center;padding:40px;color:var(--muted)}.empty .ic{font-size:48px;margin-bottom:12px;opacity:.5}
@media(max-width:1100px){.stats{grid-template-columns:repeat(3,1fr)}.g2,.g3{grid-template-columns:1fr}.cards{grid-template-columns:1fr}}
@media(max-width:768px){.side{display:none}.main{margin-left:0}}
</style>
</head>
<body>

<?php if (!$loggedIn): ?>
<!-- LOGIN -->
<div class="login">
<div class="login-box">
<h1>🎰 RifaManager <span class="ver">PRO v3</span></h1>
<form id="loginForm">
<div class="fg"><label>Usuário</label><input type="text" id="user" required></div>
<div class="fg"><label>Senha</label><input type="password" id="pass" required></div>
<button type="submit" class="btn btn-p btn-block">🔐 Entrar</button>
</form>
</div>
</div>
<script>
document.getElementById('loginForm').onsubmit=async function(e){
e.preventDefault();
const f=new FormData();
f.append('action','login');
f.append('user',document.getElementById('user').value);
f.append('pass',document.getElementById('pass').value);
const r=await(await fetch('../api/index.php',{method:'POST',body:f})).json();
if(r.success)location.reload();else alert(r.error||'Erro');
};
</script>

<?php else: ?>
<!-- APP -->
<div class="app">
<div class="side">
<div class="logo"><div class="logo-i">🎰</div><div class="logo-t">Rifa<span>Manager</span><small>PRO v3</small></div></div>
<div class="nav-i active" data-p="dash">📊 Dashboard</div>
<div class="nav-i" data-p="offers">🎁 Ofertas <span class="nav-b" id="nOff">0</span></div>
<div class="nav-i" data-p="gw">💳 Gateways</div>
<div class="side-f"><div class="user" onclick="logout()"><div class="user-a">A</div><div><div style="font-size:13px;font-weight:600">Admin</div><div style="font-size:10px;color:var(--muted)">Sair</div></div></div></div>
</div>
<div class="main">

<!-- DASHBOARD -->
<div class="page active" id="p-dash">
<div class="hdr"><div><h1>📊 Dashboard</h1><p>Visão geral do sistema</p></div><div class="hdr-a"><button class="btn btn-p" onclick="openM('new')">➕ Nova Oferta</button></div></div>
<div class="stats">
<div class="st"><div class="st-v" id="sA">0</div><div class="st-l">Acessos</div></div>
<div class="st"><div class="st-v" id="sP">0</div><div class="st-l">Aprovados</div></div>
<div class="st"><div class="st-v" id="sB">0</div><div class="st-l">Bloqueados</div></div>
<div class="st"><div class="st-v" id="sR">R$0</div><div class="st-l">Receita</div></div>
<div class="st"><div class="st-v" id="sO">0</div><div class="st-l">Ofertas</div></div>
</div>
<div class="cards" id="offerCards"></div>
</div>

<!-- OFERTAS -->
<div class="page" id="p-offers">
<div class="hdr"><div><h1>🎁 Ofertas</h1><p>Gerencie suas ofertas</p></div><div class="hdr-a"><button class="btn btn-p" onclick="openM('new')">➕ Nova Oferta</button></div></div>
<div class="cards" id="offerCards2"></div>
</div>

<!-- GATEWAYS -->
<div class="page" id="p-gw">
<div class="hdr"><div><h1>💳 Gateways</h1><p>Configure seus gateways de pagamento</p></div><div class="hdr-a"><button class="btn btn-p" onclick="openM('gw')">➕ Novo Gateway</button></div></div>
<div id="gwCards"></div>
</div>

</div>
</div>

<!-- Modal Nova Oferta -->
<div class="modal" id="m-new"><div class="modal-c">
<div class="modal-h"><div class="modal-t">➕ Nova Oferta</div><button class="modal-x" onclick="closeM('new')">×</button></div>
<div class="modal-b">
<div class="fg"><label>Slug (identificador)</label><input type="text" id="nSlug" placeholder="rifa-moto"><small>Apenas letras, números e hífen</small></div>
<div class="fg"><label>Nome</label><input type="text" id="nName" placeholder="Rifa de Moto Honda"></div>
<div class="fg"><label>URL Real (checkout)</label><input type="url" id="nReal" placeholder="https://seucheckout.com/oferta"></div>
<div class="fg"><label>URL White (página segura)</label><input type="url" id="nWhite" placeholder="https://google.com/"></div>
<div class="grid g2">
<div class="fg"><label>Token de Tráfego</label><input type="text" id="nToken" value="cm2025pro"></div>
<div class="fg"><label>Domínio Principal</label><input type="text" id="nDom" placeholder="oferta01.com"></div>
</div>
</div>
<div class="modal-f"><button class="btn btn-s" onclick="closeM('new')">Cancelar</button><button class="btn btn-p" onclick="createOffer()">🚀 Criar</button></div>
</div></div>

<!-- Modal Config -->
<div class="modal" id="m-cfg"><div class="modal-c" style="max-width:900px">
<div class="modal-h"><div class="modal-t">⚙️ <span id="cfgTitle"></span></div><button class="modal-x" onclick="closeM('cfg')">×</button></div>
<div class="modal-b"><input type="hidden" id="cfgId">
<div class="tabs">
<div class="tab active" data-t="geral">📋 Geral</div>
<div class="tab" data-t="doms">🌐 Domínios</div>
<div class="tab" data-t="cloak">🛡️ Cloaker</div>
<div class="tab" data-t="pay">💳 Gateway</div>
<div class="tab" data-t="fb">📱 Pixel</div>
<div class="tab" data-t="utm">🔗 UTMify</div>
</div>
<div class="tab-c active" id="t-geral">
<div class="fg"><label>Nome</label><input type="text" id="cNome"></div>
<div class="grid g2"><div class="fg"><label>URL Real</label><input type="url" id="cReal"></div><div class="fg"><label>URL White</label><input type="url" id="cWhite"></div></div>
<div class="grid g2"><div class="fg"><label>Preço</label><input type="text" id="cPrice"></div><div class="fg"><label>Status</label><select id="cStatus"><option value="active">Ativa</option><option value="paused">Pausada</option></select></div></div>
</div>
<div class="tab-c" id="t-doms">
<p style="color:var(--muted);font-size:12px;margin-bottom:16px">Domínios que apontam para esta oferta.</p>
<div id="domList"></div>
<div class="grid g2" style="margin-top:16px"><div class="fg"><label>Adicionar Domínio</label><input type="text" id="newDom" placeholder="novodominio.com"></div><div class="fg"><label>&nbsp;</label><button class="btn btn-g btn-sm" onclick="addDomain()">➕ Adicionar</button></div></div>
</div>
<div class="tab-c" id="t-cloak">
<div class="toggle"><div class="toggle-sw on" id="ckOn" onclick="tgl(this)"></div><div class="toggle-lbl">Cloaker Ativo</div></div>
<div class="grid g2"><div class="fg"><label>Token</label><input type="text" id="ckToken"></div><div class="fg"><label>Parâmetro</label><input type="text" id="ckParam" value="ck"></div></div>
<div class="grid g2">
<div class="toggle"><div class="toggle-sw on" id="ckVpn" onclick="tgl(this)"></div><div class="toggle-lbl">Block VPN</div></div>
<div class="toggle"><div class="toggle-sw on" id="ckDc" onclick="tgl(this)"></div><div class="toggle-lbl">Block Datacenter</div></div>
</div>
<div class="fg"><label>Países (JSON)</label><input type="text" id="ckCountry" value='["BR"]'></div>
</div>
<div class="tab-c" id="t-pay">
<div class="fg"><label>Gateway</label><select id="cGw"></select></div>
<div class="fg"><label>API Key Customizada</label><input type="text" id="cGwKey" placeholder="Deixe vazio para usar padrão"></div>
<div class="fg"><label>Company ID Customizado</label><input type="text" id="cGwComp"></div>
</div>
<div class="tab-c" id="t-fb">
<div class="fg"><label>Facebook Pixel ID</label><input type="text" id="fbPx"></div>
<div class="fg"><label>Access Token</label><textarea id="fbTk" rows="2"></textarea></div>
<div class="toggle"><div class="toggle-sw" id="fbCapi" onclick="tgl(this)"></div><div class="toggle-lbl">CAPI Ativo</div></div>
</div>
<div class="tab-c" id="t-utm">
<div class="toggle"><div class="toggle-sw" id="utmOn" onclick="tgl(this)"></div><div class="toggle-lbl">UTMify Ativo</div></div>
<div class="fg"><label>Token</label><input type="text" id="utmTk"></div>
<div class="fg"><label>Project ID</label><input type="text" id="utmPj"></div>
</div>
</div>
<div class="modal-f"><button class="btn btn-c btn-sm" onclick="downloadZip()">📦 Baixar ZIP</button><button class="btn btn-s" onclick="closeM('cfg')">Fechar</button><button class="btn btn-p" onclick="saveConfig()">💾 Salvar</button></div>
</div></div>

<!-- Modal Gateway -->
<div class="modal" id="m-gw"><div class="modal-c" style="max-width:700px">
<div class="modal-h"><div class="modal-t">💳 Novo Gateway</div><button class="modal-x" onclick="closeM('gw')">×</button></div>
<div class="modal-b">
<div class="grid g2"><div class="fg"><label>Slug</label><input type="text" id="gSlug" placeholder="allowpay"></div><div class="fg"><label>Nome</label><input type="text" id="gName" placeholder="AllowPay"></div></div>
<div class="fg"><label>URL API</label><input type="url" id="gUrl"></div>
<div class="fg"><label>API Key</label><input type="text" id="gKey"></div>
<div class="grid g2"><div class="fg"><label>Company ID</label><input type="text" id="gComp"></div><div class="fg"><label>Auth Type</label><select id="gAuth"><option value="apikey">API Key</option><option value="basic">Basic Auth</option><option value="bearer">Bearer</option></select></div></div>
<div class="grid g2"><div class="fg"><label>Auth Header</label><input type="text" id="gHeader" value="x-api-key"></div><div class="fg"><label>Status Field</label><input type="text" id="gStatus" value="status"></div></div>
<div class="grid g2"><div class="fg"><label>QR Code Field</label><input type="text" id="gQr" value="pix.qrcode"></div><div class="fg"><label>TX ID Field</label><input type="text" id="gTx" value="id"></div></div>
</div>
<div class="modal-f"><button class="btn btn-s" onclick="closeM('gw')">Cancelar</button><button class="btn btn-p" onclick="createGateway()">💾 Salvar</button></div>
</div></div>

<script>
const API='../api/index.php';
let D={offers:[],gateways:[]};

document.querySelectorAll('.nav-i').forEach(n=>n.onclick=function(){const p=this.dataset.p;if(!p)return;document.querySelectorAll('.nav-i').forEach(x=>x.classList.remove('active'));this.classList.add('active');document.querySelectorAll('.page').forEach(x=>x.classList.remove('active'));document.getElementById('p-'+p)?.classList.add('active');});
document.querySelectorAll('.tab').forEach(t=>t.onclick=function(){const x=this.dataset.t;document.querySelectorAll('.tab').forEach(i=>i.classList.remove('active'));this.classList.add('active');document.querySelectorAll('.tab-c').forEach(i=>i.classList.remove('active'));document.getElementById('t-'+x)?.classList.add('active');});

async function api(a,d={}){const f=new FormData();f.append('action',a);for(const[k,v]of Object.entries(d))f.append(k,v);const r=await fetch(API,{method:'POST',body:f});return r.json();}

async function load(){await Promise.all([loadStats(),loadOffers(),loadGateways()]);}
async function loadStats(){const r=await api('stats');if(r.success){const d=r.data;document.getElementById('sA').textContent=fmt(d.access);document.getElementById('sP').textContent=fmt(d.passed);document.getElementById('sB').textContent=fmt(d.blocked);document.getElementById('sR').textContent='R$'+fmtM(d.revenue);document.getElementById('sO').textContent=d.offers;}}
async function loadOffers(){const r=await api('offers');if(r.success){D.offers=r.data||[];renderOffers();document.getElementById('nOff').textContent=D.offers.length;}}
async function loadGateways(){const r=await api('gateways');if(r.success){D.gateways=r.data||[];renderGateways();updGwSelect();}}

function renderOffers(){const h=D.offers.map(o=>{const doms=o.domains||[];const st=o.status==='active';const cols=['#f59e0b,#ef4444','#10b981,#059669','#8b5cf6,#d946ef','#06b6d4,#0284c7'];
return`<div class="card"><div class="card-h"><div class="card-i"><div class="card-th" style="background:linear-gradient(135deg,${cols[o.id%4]})">${o.emoji||'🎁'}</div><div><div class="card-n">${o.name}</div><div class="card-m"><span class="card-slug">${o.slug}</span></div></div></div><div class="card-st ${st?'on':'off'}">${st?'Ativa':'Pausada'}</div></div>
<div class="card-stats"><div class="card-stat"><div class="card-stat-v" style="color:var(--green)">${fmt(o.stats_passed||0)}</div><div class="card-stat-l">Pass</div></div><div class="card-stat"><div class="card-stat-v" style="color:var(--red)">${fmt(o.stats_blocked||0)}</div><div class="card-stat-l">Block</div></div><div class="card-stat"><div class="card-stat-v" style="color:var(--cyan)">${o.domains_count||0}</div><div class="card-stat-l">Doms</div></div><div class="card-stat"><div class="card-stat-v" style="color:var(--purple)">R$${fmtM(o.stats_revenue||0)}</div><div class="card-stat-l">Receita</div></div></div>
<div class="card-cfg"><span class="cfg ${o.cloaker_enabled?'on':'off'}">🛡️Cloaker</span><span class="cfg ${o.fb_pixel_id?'on':'off'}">📱Pixel</span><span class="cfg ${o.utmify_enabled?'on':'off'}">🔗UTM</span><span class="cfg ${o.gateway_id?'on':'off'}">💳${o.gateway_name||'---'}</span></div>
${doms.length?`<div class="card-doms">${doms.map(d=>`<span class="dom-tag">🌐 ${d.domain}</span>`).join('')}</div>`:''}
<div class="card-a"><button class="btn btn-p btn-sm" onclick="openConfig(${o.id})">⚙️ Config</button><button class="btn btn-c btn-sm" onclick="downloadOffer(${o.id})">📦 ZIP</button>${st?`<button class="btn btn-s btn-sm" onclick="toggleOffer(${o.id},'paused')">⏸️</button>`:`<button class="btn btn-g btn-sm" onclick="toggleOffer(${o.id},'active')">▶️</button>`}<button class="btn btn-d btn-sm" onclick="deleteOffer(${o.id})">🗑️</button></div></div>`;}).join('')||'<div class="empty"><div class="ic">📭</div><p>Nenhuma oferta criada</p></div>';
document.getElementById('offerCards').innerHTML=h;document.getElementById('offerCards2').innerHTML=h;}

function renderGateways(){document.getElementById('gwCards').innerHTML=D.gateways.map(g=>`<div class="gw ${g.is_default?'active':''}"><div class="gw-h"><span class="gw-n">${g.name}</span><span class="gw-bd ${g.is_default?'on':'off'}">${g.is_default?'PADRÃO':'OK'}</span></div><div class="gw-i"><p>URL: ${g.api_url}</p><p>Auth: ${g.auth_type}</p></div><div style="display:flex;gap:6px">${!g.is_default?`<button class="btn btn-g btn-sm" onclick="setDefaultGw(${g.id})">✓ Padrão</button>`:''}<button class="btn btn-d btn-sm" onclick="deleteGw(${g.id})">🗑️</button></div></div>`).join('')||'<p style="color:var(--muted)">Nenhum gateway cadastrado</p>';}

function updGwSelect(){const s=document.getElementById('cGw');if(s)s.innerHTML='<option value="">Usar padrão</option>'+D.gateways.map(g=>`<option value="${g.id}">${g.name}${g.is_default?' (padrão)':''}</option>`).join('');}

async function createOffer(){const d={slug:document.getElementById('nSlug').value.trim(),name:document.getElementById('nName').value.trim(),real_url:document.getElementById('nReal').value.trim(),white_url:document.getElementById('nWhite').value.trim(),token:document.getElementById('nToken').value.trim(),domain:document.getElementById('nDom').value.trim()};if(!d.slug||!d.name||!d.real_url)return alert('Preencha slug, nome e URL real');const r=await api('offer_create',d);if(r.success){closeM('new');load();toast('Oferta criada!');}else alert(r.error);}
async function deleteOffer(id){if(!confirm('Excluir esta oferta?'))return;await api('offer_delete',{id});load();toast('Excluído');}
async function toggleOffer(id,st){await api('offer_toggle',{id,status:st});load();}

async function openConfig(id){const r=await api('offer',{id});if(!r.success)return alert(r.error);const o=r.data;document.getElementById('cfgId').value=id;document.getElementById('cfgTitle').textContent=o.name;
document.getElementById('cNome').value=o.name||'';document.getElementById('cReal').value=o.real_page_url||'';document.getElementById('cWhite').value=o.white_page_url||'';document.getElementById('cPrice').value=o.price_per_number||'';document.getElementById('cStatus').value=o.status||'active';
renderDomList(o.domains||[]);
setTgl('ckOn',o.cloaker_enabled);document.getElementById('ckToken').value=o.traffic_token||'';document.getElementById('ckParam').value=o.token_param||'ck';setTgl('ckVpn',o.block_vpn);setTgl('ckDc',o.block_datacenter);document.getElementById('ckCountry').value=o.allowed_countries||'["BR"]';
document.getElementById('cGw').value=o.gateway_id||'';document.getElementById('cGwKey').value=o.gateway_custom_key||'';document.getElementById('cGwComp').value=o.gateway_custom_company||'';
document.getElementById('fbPx').value=o.fb_pixel_id||'';document.getElementById('fbTk').value=o.fb_access_token||'';setTgl('fbCapi',o.fb_capi_enabled);
setTgl('utmOn',o.utmify_enabled);document.getElementById('utmTk').value=o.utmify_token||'';document.getElementById('utmPj').value=o.utmify_project_id||'';
document.querySelectorAll('.tab').forEach((t,i)=>t.classList.toggle('active',i===0));document.querySelectorAll('.tab-c').forEach((t,i)=>t.classList.toggle('active',i===0));
openM('cfg');}

function renderDomList(doms){document.getElementById('domList').innerHTML=doms.length?doms.map(d=>`<div style="display:flex;align-items:center;gap:8px;padding:8px 0;border-bottom:1px solid var(--border)"><span style="flex:1">🌐 ${d.domain}</span><button class="btn btn-d btn-sm" onclick="deleteDomain(${d.id})">×</button></div>`).join(''):'<p style="color:var(--muted);font-size:12px">Nenhum domínio</p>';}

async function addDomain(){const dom=document.getElementById('newDom').value.trim();if(!dom)return;const id=document.getElementById('cfgId').value;const r=await api('domain_add',{offer_id:id,domain:dom});if(r.success){document.getElementById('newDom').value='';openConfig(id);toast('Domínio adicionado!');}else alert(r.error);}
async function deleteDomain(id){const oid=document.getElementById('cfgId').value;await api('domain_delete',{id});openConfig(oid);}

async function saveConfig(){const id=document.getElementById('cfgId').value;
await api('offer_update',{id,name:document.getElementById('cNome').value,real_url:document.getElementById('cReal').value,white_url:document.getElementById('cWhite').value,price:document.getElementById('cPrice').value,status:document.getElementById('cStatus').value});
await api('offer_cloaker',{id,enabled:getTgl('ckOn')?1:'',token:document.getElementById('ckToken').value,param:document.getElementById('ckParam').value,block_vpn:getTgl('ckVpn')?1:'',block_dc:getTgl('ckDc')?1:'',countries:document.getElementById('ckCountry').value,mobile:1,desktop:1,tablet:1});
await api('offer_gateway',{id,gateway_id:document.getElementById('cGw').value,custom_key:document.getElementById('cGwKey').value,custom_company:document.getElementById('cGwComp').value});
await api('offer_pixel',{id,pixel_id:document.getElementById('fbPx').value,access_token:document.getElementById('fbTk').value,capi:getTgl('fbCapi')?1:''});
await api('offer_utmify',{id,enabled:getTgl('utmOn')?1:'',token:document.getElementById('utmTk').value,project:document.getElementById('utmPj').value});
load();toast('Configurações salvas!');}

async function downloadZip(){const id=document.getElementById('cfgId').value;toast('Gerando ZIP...');const r=await api('offer_generate',{id});if(r.success)window.location.href=API+'?action=download&file='+r.zip;else alert(r.error||'Erro ao gerar');}
async function downloadOffer(id){toast('Gerando ZIP...');const r=await api('offer_generate',{id});if(r.success)window.location.href=API+'?action=download&file='+r.zip;else alert(r.error||'Erro ao gerar');}

async function createGateway(){const d={slug:document.getElementById('gSlug').value.trim().toLowerCase(),name:document.getElementById('gName').value.trim(),api_url:document.getElementById('gUrl').value.trim(),api_key:document.getElementById('gKey').value,company_id:document.getElementById('gComp').value,auth_type:document.getElementById('gAuth').value,auth_header:document.getElementById('gHeader').value,status_field:document.getElementById('gStatus').value,qrcode_field:document.getElementById('gQr').value,txid_field:document.getElementById('gTx').value};if(!d.slug||!d.name||!d.api_url)return alert('Preencha slug, nome e URL');const r=await api('gateway_create',d);if(r.success){closeM('gw');loadGateways();toast('Gateway criado!');}else alert(r.error);}
async function setDefaultGw(id){await api('gateway_default',{id});loadGateways();toast('Gateway padrão definido!');}
async function deleteGw(id){if(!confirm('Excluir gateway?'))return;await api('gateway_delete',{id});loadGateways();}

function openM(n){document.getElementById('m-'+n).classList.add('active');}
function closeM(n){document.getElementById('m-'+n).classList.remove('active');}
document.querySelectorAll('.modal').forEach(m=>m.onclick=e=>{if(e.target===m)m.classList.remove('active');});
function tgl(el){el.classList.toggle('on');}
function setTgl(id,v){const el=document.getElementById(id);if(el)el.classList.toggle('on',!!v);}
function getTgl(id){const el=document.getElementById(id);return el?el.classList.contains('on'):false;}
function fmt(n){return new Intl.NumberFormat('pt-BR').format(n||0);}
function fmtM(n){return new Intl.NumberFormat('pt-BR',{minimumFractionDigits:2}).format((n||0)/100);}
function toast(m){const t=document.createElement('div');t.className='toast';t.textContent=m;document.body.appendChild(t);setTimeout(()=>t.remove(),3000);}
function logout(){api('logout').then(()=>location.reload());}

load();
</script>
<?php endif; ?>
</body>
</html>
