# 🎰 RifaManager Pro v3 - Guia de Instalação

## 📋 Requisitos
- PHP 7.4 ou superior
- Extensões: PDO, PDO_SQLite, cURL, JSON, ZIP
- Hospedagem com cPanel ou similar

---

## 🚀 Instalação (5 minutos)

### Passo 1: Upload dos Arquivos

1. Extraia o arquivo `rifa-manager-pro-v3.zip`
2. Faça upload da pasta para seu servidor, por exemplo:
   ```
   /home/usuario/public_html/painel/
   ```
   Ou em um subdomínio:
   ```
   /home/usuario/admin.seusite.com/
   ```

### Passo 2: Permissões

Via cPanel > Gerenciador de Arquivos, ou via SSH:

```bash
chmod 755 /caminho/para/painel/
chmod 777 /caminho/para/painel/database/
```

### Passo 3: Acessar o Painel

Acesse no navegador:
```
https://seusite.com/painel/admin/
```

**Credenciais padrão:**
- Usuário: `admin`
- Senha: `rifa@2026`

✅ O banco de dados SQLite será criado automaticamente em `database/rifa.db`

---

## ⚙️ Configuração Inicial

### 1. Adicionar Gateway de Pagamento

1. No painel, clique em **💳 Gateways**
2. Clique em **➕ Adicionar**
3. Preencha os dados do seu gateway:

**Exemplo AllowPay:**
```
Slug: allowpay
Nome: AllowPay
URL API: https://api.allowpay.com.br
API Key: sua-api-key
Auth Type: API Key
Auth Header: x-api-key
Status Field: status
QR Code Field: pix.qrcode
TX ID Field: id
```

**Exemplo Umbrella:**
```
Slug: umbrella
Nome: Umbrella Pay
URL API: https://api.umbrella.com.br
API Key: sua-api-key
Company ID: seu-company-id
Auth Type: Basic Auth
Auth Header: Authorization
```

4. Clique no ✓ para definir como padrão

### 2. Criar Primeira Oferta

1. Clique em **➕ Nova Oferta**
2. Preencha:
   - **Slug:** rifa-moto (identificador único)
   - **Nome:** Rifa de Moto Honda
   - **URL Real:** https://seucheckout.com/moto
   - **URL White:** https://google.com/
   - **Token:** cm2025pro
   - **Domínio:** oferta01.com (opcional)

3. Clique em **🚀 Criar**

### 3. Configurar a Oferta

Clique em **⚙️ Config** na oferta criada:

#### Aba 🌐 Domínios
Adicione todos os domínios que vão apontar para esta oferta:
- oferta01.com
- rifamoto.com
- promo-moto.com

#### Aba 🛡️ Cloaker
- Token: seu token de tráfego
- Block VPN: ✅
- Block Datacenter: ✅
- Países: ["BR"]

#### Aba 💳 Gateway
- Selecione o gateway
- Ou adicione API Key customizada para esta oferta

#### Aba 📱 Pixel
- Facebook Pixel ID: 123456789
- Access Token: EAAxxxx...
- CAPI Ativo: ✅ (recomendado)

#### Aba 🔗 UTMify
- UTMify Ativo: ✅
- Token: seu_token_utmify
- Project ID: seu_project_id

4. Clique em **💾 Salvar**

### 4. Baixar Arquivos da Oferta

1. Clique em **📦 ZIP** na oferta
2. Será baixado um arquivo `rifa-moto.zip`

---

## 📂 Instalação dos Arquivos da Oferta

### No cPanel:

1. **Crie a pasta da oferta:**
   ```
   /home/usuario/ofertas/rifa-moto/
   ```

2. **Faça upload e extraia o ZIP** nessa pasta

3. **Aponte os domínios** (cPanel > Domínios > Adicionar):
   
   | Domínio | Aponta para |
   |---------|-------------|
   | oferta01.com | /home/usuario/ofertas/rifa-moto/ |
   | rifamoto.com | /home/usuario/ofertas/rifa-moto/ |
   | promo-moto.com | /home/usuario/ofertas/rifa-moto/ |

4. **Configure SSL** para cada domínio (cPanel > SSL/TLS)

### Estrutura Final:
```
/home/usuario/
├── public_html/
│   └── painel/              ← Painel Admin
│       ├── admin/
│       ├── api/
│       ├── database/
│       │   └── rifa.db      ← Banco SQLite (auto-criado)
│       └── includes/
│
└── ofertas/
    ├── rifa-moto/           ← Arquivos da oferta
    │   ├── config.php
    │   ├── index.php
    │   ├── CloakerPro.php
    │   ├── api/
    │   ├── assets/
    │   ├── data/
    │   └── logs/
    │
    ├── bmw-x1/              ← Outra oferta
    └── iphone-16/           ← Outra oferta
```

---

## 🔗 URLs de Tráfego

Envie o tráfego com o token:
```
https://oferta01.com/?ck=cm2025pro
https://rifamoto.com/?ck=cm2025pro
```

- ✅ Com token válido → Vai para página real (checkout)
- ❌ Sem token/inválido → Vai para página white (Google)

---

## 🔄 Webhook (Notificações de Pagamento)

Configure no seu gateway o webhook:
```
https://oferta01.com/api/webhook.php
```

O sistema irá:
1. Receber a notificação
2. Atualizar o status da transação
3. Disparar evento no Facebook (se CAPI ativo)
4. Registrar no UTMify (se ativo)

---

## 📊 Consultando Status de Pagamento

```
GET https://oferta01.com/api/status.php?tx_ref=TX123456
```

Resposta:
```json
{
  "success": true,
  "status": "paid",
  "paid_at": "2025-01-13 10:30:00"
}
```

---

## 🛠️ Troubleshooting

### Erro de permissão no banco
```bash
chmod 777 database/
chmod 666 database/rifa.db
```

### Erro 500
Verifique se as extensões PHP estão ativas:
```php
<?php
phpinfo();
```
Procure por: PDO, pdo_sqlite, curl, json, zip

### Cloaker não funciona
1. Verifique se o .htaccess foi enviado
2. Verifique se mod_rewrite está ativo
3. Teste a URL com token: `?ck=seutoken`

### Gateway não funciona
1. Verifique URL da API
2. Verifique API Key
3. Teste no painel: veja os logs em `logs/`

---

## 🔐 Segurança

### Alterar senha do admin

Edite o banco SQLite:
```sql
UPDATE config SET config_value = 'nova_senha' WHERE config_key = 'admin_pass';
```

Ou via phpLiteAdmin / DB Browser for SQLite

### Proteger pasta do painel

Adicione no `.htaccess` da pasta admin:
```apache
<Files "*.db">
    Require all denied
</Files>
```

---

## 📞 Suporte

- Verifique os logs em `logs/` de cada oferta
- Webhook logs em `logs/webhook_*.log`
- Erros do PHP no error_log do servidor

---

## ✅ Checklist de Instalação

- [ ] Upload do painel
- [ ] Permissões 777 na pasta database/
- [ ] Acessou o painel e logou
- [ ] Adicionou gateway
- [ ] Criou oferta
- [ ] Configurou Pixel/UTMify
- [ ] Baixou ZIP da oferta
- [ ] Fez upload dos arquivos da oferta
- [ ] Apontou domínios no cPanel
- [ ] Configurou SSL
- [ ] Configurou webhook no gateway
- [ ] Testou URL com token
- [ ] Testou pagamento

🎉 **Pronto! Sistema funcionando!**
